CREATE OR REPLACE FUNCTION tlog.Auditlog_parent_fname( _tabname varchar ) RETURNS VARCHAR AS $$
  DECLARE fname varchar;
  BEGIN
    CASE _tabname
       WHEN 'ab2'                              THEN fname := 'a2_ab_ix';
       WHEN 'ab2ba'                            THEN fname := 'a2ba_a2_id';
       WHEN 'abk'                              THEN fname := 'ab_ix';
       WHEN 'adk'                              THEN fname := 'ad_krz';
       WHEN 'adk_adresses'                     THEN fname := 'ada_ad_krz';
       WHEN 'adk1'                             THEN fname := 'a1_krz';
       WHEN 'adk2'                             THEN fname := 'a2_krz';
       WHEN 'adkap'                            THEN fname := 'ap_ad_krz';
       WHEN 'anl'                              THEN fname := 'an_nr';
       WHEN 'art'                              THEN fname := 'ak_nr';
       WHEN 'artblang'                         THEN fname := 'akbl_ak_nr';
       WHEN 'artcod'                           THEN fname := 'ac_n';
       WHEN 'artcodlang'                       THEN fname := 'acl_ac_n';
       WHEN 'artdlang'                         THEN fname := 'akdl_ak_nr';
       WHEN 'artdokutxt'                       THEN fname := 'adtx_ak_nr';
       WHEN 'artinfo'                          THEN fname := 'ain_ak_nr';
       WHEN 'artmlang'                         THEN fname := 'akml_ak_nr';
       WHEN 'artoption_arts'                   THEN fname := 'aoa_g_ak_nr';
       WHEN 'artpr'                            THEN fname := 'pr_id';
       WHEN 'artpruefung'                      THEN fname := 'apr_aknr';
       WHEN 'artpruefungtest'                  THEN fname := 'aprt_id';
       WHEN 'artrab'                           THEN fname := 'rab_aknr';
       WHEN 'artstp'                           THEN fname := 'astp_aknr';
       WHEN 'artvkp'                           THEN fname := 'vkp_aknr';
       WHEN 'artzuo'                           THEN fname := 'az_pronr';
       WHEN 'artzust'                          THEN fname := 'az_aknr';
       WHEN 'auftg'                            THEN fname := 'ag_id';
       WHEN 'auftgabzu'                        THEN fname := 'az_ag_id';
       WHEN 'auftgdokutxt'                     THEN fname := 'atd_dokunr';
       WHEN 'auftgmatinfo'                     THEN fname := 'agmi_ag_id';
       WHEN 'bdea'                             THEN fname := 'ba_id';
       WHEN 'bdeabgruende'                     THEN fname := 'ab_id';
       WHEN 'bdep'                             THEN fname := 'bd_minr';
       WHEN 'bdepab'                           THEN fname := 'bdab_minr';
       WHEN 'beleg_k__artchange'               THEN fname := 'k_id';
       WHEN 'beleg_p__artchange'               THEN fname := 'p_k_id';
       WHEN 'beleg_p__artchange__vorkalk'      THEN fname := 'p_id';
       WHEN 'belegabzu'                        THEN fname := 'belaz_dokument_id';
       WHEN 'belegdokument'                    THEN fname := 'beld_id';
       WHEN 'belegpos'                         THEN fname := 'belp_dokument_id';
       WHEN 'belegposabzu'                     THEN fname := 'belpaz_belegpos_id';
       WHEN 'belkopf'                          THEN fname := 'be_bnr';
       WHEN 'belzeil_auftg_lif'                THEN fname := 'bz_bz_be_bnr';
       WHEN 'belzeil_grund'                    THEN fname := 'bz_bz_be_bnr';
       WHEN 'bestanfpos'                       THEN fname := 'bap_banr';
       WHEN 'bestanftxt'                       THEN fname := 'ba_nr';
       WHEN 'bewa'                             THEN fname := 'wa_einh';
       WHEN 'cocpos'                           THEN fname := 'cocp_id';
       WHEN 'eingrechdokument'                 THEN fname := 'beld_id';
       WHEN 'epreis'                           THEN fname := 'e_aknr';
       WHEN 'epreisabzu'                       THEN fname := 'eaz_e_id';
       WHEN 'epreisstaffel'                    THEN fname := 'est_e_id';
       WHEN 'eprzutxt'                         THEN fname := 'ezt_aknr';
       WHEN 'invrech'                          THEN fname := 'ir_ad_krz';
       WHEN 'karenz'                           THEN fname := 'kr_tpl_name';
       WHEN 'ksv'                              THEN fname := 'ks_abt';
       WHEN 'ksv_werkzeuge'                    THEN fname := 'ksw_ks_abt';
       WHEN 'kundanfrage'                      THEN fname := 'kanf_nr';
       WHEN 'kundanfragepos'                   THEN fname := 'kanfp_kanf_nr';
       WHEN 'lagartikelkonf'                   THEN fname := 'lgoa_aknr';
       WHEN 'ldsabzu'                          THEN fname := 'ldaz_ld_id';
       WHEN 'ldsdok'                           THEN fname := 'ld_id';
       WHEN 'ldsdokdokutxt'                    THEN fname := 'ltd_dokunr';
       WHEN 'ldsdoktxt'                        THEN fname := 'ldt_auftg';
       WHEN 'lifschpack'                       THEN fname := 'lp_l_dokunr';
       WHEN 'llv'                              THEN fname := 'll_minr';
       WHEN 'llv_stuko_history'                THEN fname := 'llsh_ll_minr';
       WHEN 'mitpln'                           THEN fname := 'mpl_minr';
       WHEN 'ncp_o2_a2_ksv'                    THEN fname := 'ncpoak_o2_id';
       WHEN 'ncprogram'                        THEN fname := 'ncp_id';
       WHEN 'op2'                              THEN fname := 'o2_ix';
       WHEN 'op2ba'                            THEN fname := 'o2ba_ix';
       WHEN 'op2ksa'                           THEN fname := 'o2ks_o2_id';
       WHEN 'op3'                              THEN fname := 'o3_ix';
       WHEN 'op5'                              THEN fname := 'o5_wz_aknr';
       WHEN 'op6'                              THEN fname := 'o6_ix';
       WHEN 'op7'                              THEN fname := 'o7_op_ix';
       WHEN 'op7zko'                           THEN fname := 'o7zk_ix';
       WHEN 'op8'                              THEN fname := 'o8_ix';
       WHEN 'opl'                              THEN fname := 'op_ix';
       WHEN 'oplpm_data'                       THEN fname := 'pm_id';
       WHEN 'oplpm_mw'                         THEN fname := 'mw_id';
       WHEN 'personal'                         THEN fname := 'pers_krz';
       WHEN 'qab'                              THEN fname := 'q_nr';
       WHEN 'qabteam'                          THEN fname := 'qteam_qnr';
       WHEN 'recnogroup'                       THEN fname := 'reg_id';
       WHEN 'recnokeyword'                     THEN fname := 'r_id';
       WHEN 'settings'                         THEN fname := 's_vari';
       WHEN 'softlink'                         THEN fname := 'slink_id';
       WHEN 'stundauszahl'                     THEN fname := 'sa_minr';
       WHEN 'stv'                              THEN fname := 'st_zn';
       WHEN 'stv_op2'                          THEN fname := 'sto2_st_id';
       WHEN 'stvrevision'                      THEN fname := 'str_resid';
       WHEN 'stvzutxt'                         THEN fname := 'stv_zn';
       WHEN 'tplan'                            THEN fname := 'tpl_name';
       WHEN 'tplanblock'                       THEN fname := 'tplbl_tpl_name';
       WHEN 'tplanpause'                       THEN fname := 'tplp_tpl_name';
       WHEN 'werkzeug'                         THEN fname := 'wz_id';
       WHEN 'werkzeug_link'                    THEN fname := 'wzl_id';
        ELSE                                       fname := null;
    END CASE;

    RETURN fname;

 END $$ LANGUAGE plpgsql;
